using Microsoft.VisualBasic;
using System;
using MicroFour.StrataFrame.Business;

namespace StrataFlix.Reporting
{
	namespace Reports
	{
		namespace MovieProfile
		{
			
			
			public class MovieProfileDataSource : ReportDataSource<MoviesBBS>
			{
				
				
				#region " Public Methods "
				
				/// <summary>
				/// Populate the data source for the report
				/// </summary>
				/// <remarks></remarks>
				public override bool PopulateDataSource()
				{
					//-- Establish Locals
					StrataFlix.UI.BrowseDialogs.MoviesBrowseDialog movieBrw = new StrataFlix.UI.BrowseDialogs.MoviesBrowseDialog();
					
					//-- Set the BO to populate
					movieBrw.BusinessObjectToPopulate = this.DataSource.SourceBO;
					
					//-- For this instance, force the focus to the results after the query so that the
					//   OK button will come on if there are any results in the list
					movieBrw.SetFocusToResultsAfterSearch = true;
					
					//-- Only return the selected record
					movieBrw.ReturnSelectedRecordOnly = true;
					
					//-- Change the header title
					movieBrw.HeaderTitle = "Movie Profile Report";
					
					//-- In this case we are just using the Movie Browse to populate the source BO.  But
					//   a custom dialog could just as easily be shown instead.
					if (movieBrw.ShowDialog() == System.Windows.Forms.DialogResult.OK)
					{
						PopulateDefinedDataSource(this.DataSource.SourceBO.mv_pk, false);
						
						//-- Indicate that the data source was populated
						return true;
					}
					else
					{
						//-- There is no reason to continue since the browse was cancelled
						return false;
					}
				}
				
				/// <summary>
				/// Populates the data source using the specified primary key
				/// </summary>
				/// <param name="moviePk"></param>
                /// <param name="includeMovieRecord"></param>
				/// <remarks></remarks>
				public void PopulateDefinedDataSource(int moviePk, bool includeMovieRecord)
				{
					if (includeMovieRecord)
					{
						//-- Populate all of the data sources
						BusinessLayer.FillMultipleDataTables(StrataFlix.Business.ApplicationQueries.MovieMaintenance_AllData(moviePk, true), this.DataSource.SourceBO, this.DataSource.SourceBO.MovieCast.SourceBO, this.DataSource.SourceBO.MovieItems.SourceBO, this.DataSource.SourceBO.MovieImages.SourceBO);
					}
					else
					{
						//-- Populate all of the data sources
						BusinessLayer.FillMultipleDataTables(StrataFlix.Business.ApplicationQueries.MovieMaintenance_AllData(moviePk, false), this.DataSource.SourceBO.MovieCast.SourceBO, this.DataSource.SourceBO.MovieItems.SourceBO, this.DataSource.SourceBO.MovieImages.SourceBO);
					}
					
					
					//-- If an image wasn't return, create an image record within the report data sources
					//   so one will print.
					if (this.DataSource.SourceBO.MovieImages.SourceBO.Count == 0)
					{
						this.DataSource.SourceBO.MovieImages.SourceBO.ParentBusinessObject = this.DataSource.SourceBO;
						this.DataSource.SourceBO.MovieImages.SourceBO.NewRow();
						this.DataSource.SourceBO.MovieImages.SourceBO.CurrentDataTable.AcceptChanges();
					}
					
					//-- Force the sort to title name
					this.DataSource.SourceBO.Sort = "mv_Title";
					this.DataSource.SourceBO.MovieCast.SourceBO.Sort = "pl_LastName, pl_FirstName, pl_MiddleName";
					
					//-- Set the report information
					this.LocalReport.DisplayName = "Movie Profile";
					this.LocalReport.ReportEmbeddedResource = "StrataFlix.Reporting.Reports.Movie_Profile_Report.MovieProfile.rdlc";
					
					//-- Create the LocalReport data sources
					this.LocalReport.DataSources.Add(new Microsoft.Reporting.WinForms.ReportDataSource("Source", this.DataSource));
					this.LocalReport.DataSources.Add(new Microsoft.Reporting.WinForms.ReportDataSource("MovieImages", this.DataSource.SourceBO.MovieImages));
					this.LocalReport.DataSources.Add(new Microsoft.Reporting.WinForms.ReportDataSource("MovieCast", this.DataSource.SourceBO.MovieCast));
					
				}
				
				#endregion
			}
			
		}
	}
}
